/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

function loadComments(url, page) {
    var request = jQuery.ajax({
        url: "ajax.comments.read.php?_LANG=" + jQuery("html").attr("lang") + "&page=" + page,
        type: 'post',
        data: 'url=' + url,
        dataType: 'html'
    });

    request.done(function (msg) {

		var parent = jQuery('#comments-data'),
			content = STBUtils.bgSchemeReplace(msg , parent.attr("data-scheme"));

        parent.html(content);
		parent.attr("data-page" , page);
    });

    request.fail(function (jqXHR, textStatus) {
        alert("Request failed: " + textStatus);
    });
}

function reLoadComments() {
    loadComments(jQuery("#comments-data").attr("data-url"), jQuery("#comments-data").attr("data-page"));
}

function reply(e) {
    try {
        e.preventDefault();

        var obj = jQuery(this);
        //remove all the replies from the replies
        jQuery(".comments").find(".comment-new.reply").slideUp(function () {
            jQuery(this).remove();
        });

        var parent = obj.closest(".comment");

        if (obj.hasClass("opened")) {

            obj.removeClass("opened");

            parent.next().slideUp("slow", function () {
                jQuery(this).remove();
            });

        } else {
            obj.addClass("opened");

            var replyform = jQuery("<div class=\"comment-new reply\">" + jQuery(".comment-new.reply").html() + "</div>");

            replyform.find("input[name=parent]").val(parent.attr('data-comment'));
            replyform.find(".reponsebox").empty();

            parent.after(
                replyform
            );

            parent.next().slideDown("slow", function () {
                jQuery(this).find("form-capcha-img").trigger("click");
            });
        }

    } catch (e) {
        getStack(0, e);
    }
}

function onClickReply() {
    try {
        jQuery(document).on('click', '.comment-reply', reply);
    } catch (e) {
        getStack(0, e);
    }
}

jQuery(document).ready(onClickReply);
